<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('partenaire_id', 'telephone', 'fonction');

    public function partenaire()
    {
        return $this->belongsTo('App\Models\GestionPartenaire\Partenaire');
    }

    public function affectations()
    {
        return $this->hasMany('App\Models\GestionSiteBusiness\AffectationAgent', 'user_id');
    }

}